package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sync_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum SyncOrderStatus {

    _1("1", "待处理"),
    _2("2", "已完成"),
    _3("3", "已取消"),
    _4("4", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SyncOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SyncOrderStatus fromCode(String code) {
        return Stream.of(SyncOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
