package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * writeoff_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum WriteoffStatus {

    _0("0", "未冲销"),
    _1("1", "冲销中"),
    _2("2", "已冲销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WriteoffStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WriteoffStatus fromCode(String code) {
        return Stream.of(WriteoffStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
