package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * dy_after_sale
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DyAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 售后单号
   */
  private String aftersaleId;
  /**
   * 申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;
  /**
   * 店铺编号
   */
  private String shopId;
  /**
   * 关联的订单ID
   */
  private String relatedId;
  /**
   * 售后完结时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime aftersaleStatusToFinalTime;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dyUpdateTime;
  /**
   * 售后退款金额
   */
  private BigDecimal refundAmount;
  /**
   * 售后退运费金额
   */
  private BigDecimal refundPostAmount;
  /**
   * 售后数量
   */
  private Long aftersaleNum;
  /**
   * 部分退类型
   */
  private Long partType;
  /**
   * 售后单创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dyCreateTime;
  /**
   * 退税金额
   */
  private BigDecimal refundTaxAmount;
  /**
   * 风控理由
   */
  private String riskdecisionReason;
  /**
   * 风控描述
   */
  private String riskDecisionDescription;
  /**
   * 退优惠金额
   */
  private BigDecimal returnPromotionAmount;
  /**
   * 退款状态
   */
  private String refundStatus;
  /**
   * 售后商家备注
   */
  private String remark;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * 单据流转处理状态
   */
  private String dealStatus;
  /**
   * 业务ID
   */
  private String businessId;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 数据MD5
   */
  private String dataMD5;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * id
   */
  private Long dyId;
  /**
   * 对账金额
   */
  private BigDecimal checkAmount;
  /**
   * 售后状态
   */
  private String aftersaleStatus;
  /**
   * 退款金额合计
   */
  private BigDecimal refundAmountSum;
  /**
   * 买家是否收到货物
   */
  private String gotPkg;
  /**
   * 售后类型
   */
  private String aftersaleType;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司税号
   */
  private String companyTaxNo;
  /**
   * 事业部名称
   */
  private String bussinessUnitName;
  /**
   * 店铺名称
   */
  private String shopName;
  /**
   * 最新版本
   */
  private Boolean latest;
  /**
   * 账期
   */
  private String accountPeriod;
  /**
   * 售后子类型
   */
  private String aftersaleSubType;
  /**
   * 是否拒签后退款
   */
  private String isAgreeRefuseSign;
  /**
   * 仲裁状态
   */
  private String arbitrateStatus;
  /**
   * 售后订单类型
   */
  private String aftersaleOrderType;
  /**
   * 退款方式
   */
  private String refundType;
  /**
   * 售后退款类型
   */
  private String aftersaleRefundType;
  /**
   * 组织树
   */
  private String orgTree;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("aftersale_id", aftersaleId);
      map.put("apply_time", BocpGenUtils.toTimestamp(applyTime));
      map.put("shop_id", shopId);
      map.put("related_id", relatedId);
      map.put("aftersale_status_to_final_time", BocpGenUtils.toTimestamp(aftersaleStatusToFinalTime));
      map.put("dy_update_time", BocpGenUtils.toTimestamp(dyUpdateTime));
      map.put("refund_amount", refundAmount);
      map.put("refund_post_amount", refundPostAmount);
      map.put("aftersale_num", aftersaleNum);
      map.put("part_type", partType);
      map.put("dy_create_time", BocpGenUtils.toTimestamp(dyCreateTime));
      map.put("refund_tax_amount", refundTaxAmount);
      map.put("riskDecision_reason", riskdecisionReason);
      map.put("risk_decision_description", riskDecisionDescription);
      map.put("return_promotion_amount", returnPromotionAmount);
      map.put("refund_status", refundStatus);
      map.put("remark", remark);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("dy_id", dyId);
      map.put("check_amount", checkAmount);
      map.put("aftersale_status", aftersaleStatus);
      map.put("refund_amount_sum", refundAmountSum);
      map.put("got_pkg", gotPkg);
      map.put("aftersale_type", aftersaleType);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("shop_name", shopName);
      map.put("latest", latest);
      map.put("account_period", accountPeriod);
      map.put("aftersale_sub_type", aftersaleSubType);
      map.put("is_agree_refuse_sign", isAgreeRefuseSign);
      map.put("arbitrate_status", arbitrateStatus);
      map.put("aftersale_order_type", aftersaleOrderType);
      map.put("refund_type", refundType);
      map.put("aftersale_refund_type", aftersaleRefundType);
      map.put("org_tree", orgTree);

      return map;
  }

  public static DyAfterSale fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    DyAfterSale entity = new DyAfterSale();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_id")) {
      Object obj = map.get("aftersale_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("related_id")) {
      Object obj = map.get("related_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelatedId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_status_to_final_time")) {
      Object obj = map.get("aftersale_status_to_final_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAftersaleStatusToFinalTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAftersaleStatusToFinalTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersaleStatusToFinalTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAftersaleStatusToFinalTime(null);
      }
    }
    if(map.containsKey("dy_update_time")) {
      Object obj = map.get("dy_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDyUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDyUpdateTime(null);
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_post_amount")) {
      Object obj = map.get("refund_post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_num")) {
      Object obj = map.get("aftersale_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAftersaleNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAftersaleNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAftersaleNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("part_type")) {
      Object obj = map.get("part_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPartType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPartType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPartType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDyCreateTime(null);
      }
    }
    if(map.containsKey("refund_tax_amount")) {
      Object obj = map.get("refund_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("riskDecision_reason")) {
      Object obj = map.get("riskDecision_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskdecisionReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_decision_description")) {
      Object obj = map.get("risk_decision_description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskDecisionDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_promotion_amount")) {
      Object obj = map.get("return_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_status")) {
      Object obj = map.get("aftersale_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount_sum")) {
      Object obj = map.get("refund_amount_sum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmountSum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmountSum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmountSum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmountSum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmountSum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("got_pkg")) {
      Object obj = map.get("got_pkg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGotPkg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_type")) {
      Object obj = map.get("aftersale_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_sub_type")) {
      Object obj = map.get("aftersale_sub_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleSubType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_agree_refuse_sign")) {
      Object obj = map.get("is_agree_refuse_sign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAgreeRefuseSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arbitrate_status")) {
      Object obj = map.get("arbitrate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArbitrateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_order_type")) {
      Object obj = map.get("aftersale_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_type")) {
      Object obj = map.get("refund_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_refund_type")) {
      Object obj = map.get("aftersale_refund_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAftersaleRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_id")) {
      Object obj = map.get("aftersale_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_time")) {
      Object obj = map.get("apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("related_id")) {
      Object obj = map.get("related_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRelatedId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_status_to_final_time")) {
      Object obj = map.get("aftersale_status_to_final_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAftersaleStatusToFinalTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAftersaleStatusToFinalTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAftersaleStatusToFinalTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAftersaleStatusToFinalTime(null);
      }
    }
    if(map.containsKey("dy_update_time")) {
      Object obj = map.get("dy_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDyUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDyUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDyUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDyUpdateTime(null);
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_post_amount")) {
      Object obj = map.get("refund_post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_num")) {
      Object obj = map.get("aftersale_num");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAftersaleNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAftersaleNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAftersaleNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("part_type")) {
      Object obj = map.get("part_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPartType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPartType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPartType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDyCreateTime(null);
      }
    }
    if(map.containsKey("refund_tax_amount")) {
      Object obj = map.get("refund_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("riskDecision_reason")) {
      Object obj = map.get("riskDecision_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRiskdecisionReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_decision_description")) {
      Object obj = map.get("risk_decision_description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRiskDecisionDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_promotion_amount")) {
      Object obj = map.get("return_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReturnPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReturnPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReturnPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReturnPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReturnPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_status")) {
      Object obj = map.get("aftersale_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount_sum")) {
      Object obj = map.get("refund_amount_sum");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundAmountSum((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundAmountSum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundAmountSum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundAmountSum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundAmountSum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("got_pkg")) {
      Object obj = map.get("got_pkg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGotPkg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_type")) {
      Object obj = map.get("aftersale_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_sub_type")) {
      Object obj = map.get("aftersale_sub_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleSubType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_agree_refuse_sign")) {
      Object obj = map.get("is_agree_refuse_sign");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsAgreeRefuseSign((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arbitrate_status")) {
      Object obj = map.get("arbitrate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setArbitrateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_order_type")) {
      Object obj = map.get("aftersale_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_type")) {
      Object obj = map.get("refund_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftersale_refund_type")) {
      Object obj = map.get("aftersale_refund_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAftersaleRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  }
}
