package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ks_settlement
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsSettlement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键
   */
  private Long ksId;
  /**
   * 租户code
   */
  private String ksTenantCode;
  /**
   * 店铺编号
   */
  private String storeId;
  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;
  /**
   * 订单编号
   */
  private String orderNo;
  /**
   * 商品id
   */
  private String productId;
  /**
   * 商品名称
   */
  private String productName;
  /**
   * 商品数量
   */
  private Long productNum;
  /**
   * 订单创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderCreateTime;
  /**
   * 订单实付
   */
  private BigDecimal actualPayAmount;
  /**
   * 平台补贴
   */
  private BigDecimal platformAllowanceAmount;
  /**
   * 主播补贴
   */
  private BigDecimal anchorHongBaoAmount;
  /**
   * 主播补贴明细
   */
  private BigDecimal hongbaoDetail;
  /**
   * 合计收入
   */
  private BigDecimal totalIncome;
  /**
   * 订单退款
   */
  private BigDecimal totalRefundAmount;
  /**
   * 技术服务费
   */
  private BigDecimal platformCommissionAmount;
  /**
   * 达人ID
   */
  private String distributorId;
  /**
   * 达人佣金
   */
  private BigDecimal distributorCommissionAmount;
  /**
   * 团长ID
   */
  private String activityUserId;
  /**
   * 团长佣金
   */
  private BigDecimal activityUserCommissionAmount;
  /**
   * 快赚客id
   */
  private String kzkId;
  /**
   * 快赚客佣金
   */
  private BigDecimal kzkCommissionAmount;
  /**
   * 服务商ID
   */
  private String serviceUserId;
  /**
   * 服务商佣金
   */
  private BigDecimal serviceAmount;
  /**
   * 服务商分账基数
   */
  private String serviceCommissionRole;
  /**
   * 分期手续费
   */
  private BigDecimal huabeiAmount;
  /**
   * 合计支出
   */
  private BigDecimal totalOutgoingAmount;
  /**
   * 商家结算状态
   */
  private String settlementStatus;
  /**
   * 实际结算金额
   */
  private BigDecimal settlementAmount;
  /**
   * 实际结算时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementTime;
  /**
   * 实际结算时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtSettlementTime;
  /**
   * 结算规则
   */
  private String settlementRule;
  /**
   * 资金渠道
   */
  private String accountChannel;
  /**
   * 账户名称
   */
  private String accountName;
  /**
   * 结算商户号
   */
  private String merchantId;
  /**
   * 备注
   */
  private String orderRemark;
  /**
   * 消费金信息
   */
  private String czjAmount;
  /**
   * 退款信息
   */
  private String refundInfo;
  /**
   * 其他收费名称
   */
  private String otherAmountDetail;
  /**
   * MCN机构
   */
  private String mcnId;
  /**
   * 其他收费金额
   */
  private BigDecimal otherAmountDesc;
  /**
   * 支付营销补贴
   */
  private BigDecimal platformPayMarketAllowanceAmount;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 其他收费金额（废弃）
   */
  private String otherAmount;
  /**
   * 单据流转处理状态
   */
  private String dealStatus;
  /**
   * 业务ID
   */
  private String businessId;
  /**
   * 数据MD5
   */
  private String dataMD5;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 最新版本
   */
  private Boolean latest;
  /**
   * 佣金模式
   */
  private String collectMode;
  /**
   * 店铺名称
   */
  private String shopName;
  /**
   * 事业部名称
   */
  private String bussinessUnitName;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司税号
   */
  private String companyTaxNo;
  /**
   * 对账金额
   */
  private BigDecimal checkAmount;
  /**
   * 销退类型
   */
  private String saleReturnStatus;
  /**
   * 账期
   */
  private String accountPeriod;
  /**
   * 账单处理状态
   */
  private String checkProcessStatus;
  /**
   * 对账订单号
   */
  private String checkOrderNo;
  /**
   * 识别标识
   */
  private Boolean recognFlag;
  /**
   * 项目-识别
   */
  private String recognItem;
  /**
   * 识别订单号
   */
  private String recognOrderId;
  /**
   * 退款订单号
   */
  private String recognRefundId;
  /**
   * 识别金额
   */
  private BigDecimal recognAmount;
  /**
   * 入账类型
   */
  private String incomeType;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ks_id", ksId);
      map.put("ks_tenant_code", ksTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("order_no", orderNo);
      map.put("product_id", productId);
      map.put("product_name", productName);
      map.put("product_num", productNum);
      map.put("order_create_time", BocpGenUtils.toTimestamp(orderCreateTime));
      map.put("actual_pay_amount", actualPayAmount);
      map.put("platform_allowance_amount", platformAllowanceAmount);
      map.put("anchor_hong_bao_amount", anchorHongBaoAmount);
      map.put("hongbao_detail", hongbaoDetail);
      map.put("total_income", totalIncome);
      map.put("total_refund_amount", totalRefundAmount);
      map.put("platform_commission_amount", platformCommissionAmount);
      map.put("distributor_id", distributorId);
      map.put("distributor_commission_amount", distributorCommissionAmount);
      map.put("activity_user_id", activityUserId);
      map.put("activity_user_commission_amount", activityUserCommissionAmount);
      map.put("kzk_id", kzkId);
      map.put("kzk_commission_amount", kzkCommissionAmount);
      map.put("service_user_id", serviceUserId);
      map.put("service_amount", serviceAmount);
      map.put("service_commission_role", serviceCommissionRole);
      map.put("huabei_amount", huabeiAmount);
      map.put("total_outgoing_amount", totalOutgoingAmount);
      map.put("settlement_status", settlementStatus);
      map.put("settlement_amount", settlementAmount);
      map.put("settlement_time", BocpGenUtils.toTimestamp(settlementTime));
      map.put("gmt_settlement_time", BocpGenUtils.toTimestamp(gmtSettlementTime));
      map.put("settlement_rule", settlementRule);
      map.put("account_channel", accountChannel);
      map.put("account_name", accountName);
      map.put("merchant_id", merchantId);
      map.put("order_remark", orderRemark);
      map.put("czj_amount", czjAmount);
      map.put("refund_info", refundInfo);
      map.put("other_amount_detail", otherAmountDetail);
      map.put("mcn_id", mcnId);
      map.put("other_amount_desc", otherAmountDesc);
      map.put("platform_pay_market_allowance_amount", platformPayMarketAllowanceAmount);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("other_amount", otherAmount);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("checkStatus", checkStatus);
      map.put("latest", latest);
      map.put("collect_mode", collectMode);
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("check_amount", checkAmount);
      map.put("sale_return_status", saleReturnStatus);
      map.put("account_period", accountPeriod);
      map.put("check_process_status", checkProcessStatus);
      map.put("check_order_no", checkOrderNo);
      map.put("recogn_flag", recognFlag);
      map.put("recogn_item", recognItem);
      map.put("recogn_order_id", recognOrderId);
      map.put("recogn_refund_id", recognRefundId);
      map.put("recognAmount", recognAmount);
      map.put("incomeType", incomeType);

      return map;
  }

  public static KsSettlement fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsSettlement entity = new KsSettlement();

    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_num")) {
      Object obj = map.get("product_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProductNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProductNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setProductNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("actual_pay_amount")) {
      Object obj = map.get("actual_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_allowance_amount")) {
      Object obj = map.get("platform_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("anchor_hong_bao_amount")) {
      Object obj = map.get("anchor_hong_bao_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAnchorHongBaoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAnchorHongBaoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("hongbao_detail")) {
      Object obj = map.get("hongbao_detail");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setHongbaoDetail((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setHongbaoDetail(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setHongbaoDetail(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHongbaoDetail(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setHongbaoDetail(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_income")) {
      Object obj = map.get("total_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_refund_amount")) {
      Object obj = map.get("total_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_commission_amount")) {
      Object obj = map.get("platform_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distributor_id")) {
      Object obj = map.get("distributor_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributorId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributor_commission_amount")) {
      Object obj = map.get("distributor_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributorCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributorCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributorCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistributorCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributorCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_id")) {
      Object obj = map.get("activity_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActivityUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_commission_amount")) {
      Object obj = map.get("activity_user_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActivityUserCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActivityUserCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActivityUserCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityUserCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActivityUserCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("kzk_id")) {
      Object obj = map.get("kzk_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKzkId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kzk_commission_amount")) {
      Object obj = map.get("kzk_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setKzkCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setKzkCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setKzkCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKzkCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setKzkCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_user_id")) {
      Object obj = map.get("service_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_amount")) {
      Object obj = map.get("service_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_commission_role")) {
      Object obj = map.get("service_commission_role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceCommissionRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("huabei_amount")) {
      Object obj = map.get("huabei_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setHuabeiAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setHuabeiAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setHuabeiAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHuabeiAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setHuabeiAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_outgoing_amount")) {
      Object obj = map.get("total_outgoing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalOutgoingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalOutgoingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalOutgoingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalOutgoingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalOutgoingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_status")) {
      Object obj = map.get("settlement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_amount")) {
      Object obj = map.get("settlement_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_time")) {
      Object obj = map.get("settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementTime(null);
      }
    }
    if(map.containsKey("gmt_settlement_time")) {
      Object obj = map.get("gmt_settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtSettlementTime(null);
      }
    }
    if(map.containsKey("settlement_rule")) {
      Object obj = map.get("settlement_rule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_channel")) {
      Object obj = map.get("account_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_id")) {
      Object obj = map.get("merchant_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("czj_amount")) {
      Object obj = map.get("czj_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCzjAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_info")) {
      Object obj = map.get("refund_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount_detail")) {
      Object obj = map.get("other_amount_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherAmountDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mcn_id")) {
      Object obj = map.get("mcn_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMcnId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount_desc")) {
      Object obj = map.get("other_amount_desc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherAmountDesc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherAmountDesc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherAmountDesc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherAmountDesc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherAmountDesc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_pay_market_allowance_amount")) {
      Object obj = map.get("platform_pay_market_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformPayMarketAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformPayMarketAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount")) {
      Object obj = map.get("other_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collect_mode")) {
      Object obj = map.get("collect_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sale_return_status")) {
      Object obj = map.get("sale_return_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_process_status")) {
      Object obj = map.get("check_process_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_order_no")) {
      Object obj = map.get("check_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_flag")) {
      Object obj = map.get("recogn_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRecognFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecognFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("recogn_item")) {
      Object obj = map.get("recogn_item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_order_id")) {
      Object obj = map.get("recogn_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_refund_id")) {
      Object obj = map.get("recogn_refund_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognRefundId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognAmount")) {
      Object obj = map.get("recognAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRecognAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRecognAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRecognAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecognAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecognAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_num")) {
      Object obj = map.get("product_num");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setProductNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setProductNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setProductNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("actual_pay_amount")) {
      Object obj = map.get("actual_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActualPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActualPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActualPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActualPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActualPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_allowance_amount")) {
      Object obj = map.get("platform_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatformAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatformAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatformAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatformAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatformAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("anchor_hong_bao_amount")) {
      Object obj = map.get("anchor_hong_bao_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAnchorHongBaoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAnchorHongBaoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAnchorHongBaoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAnchorHongBaoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAnchorHongBaoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("hongbao_detail")) {
      Object obj = map.get("hongbao_detail");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setHongbaoDetail((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setHongbaoDetail(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setHongbaoDetail(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHongbaoDetail(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setHongbaoDetail(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_income")) {
      Object obj = map.get("total_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_refund_amount")) {
      Object obj = map.get("total_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_commission_amount")) {
      Object obj = map.get("platform_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatformCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatformCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatformCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatformCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatformCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distributor_id")) {
      Object obj = map.get("distributor_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDistributorId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributor_commission_amount")) {
      Object obj = map.get("distributor_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDistributorCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDistributorCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDistributorCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDistributorCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDistributorCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_id")) {
      Object obj = map.get("activity_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setActivityUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_commission_amount")) {
      Object obj = map.get("activity_user_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setActivityUserCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setActivityUserCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setActivityUserCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActivityUserCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setActivityUserCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("kzk_id")) {
      Object obj = map.get("kzk_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKzkId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kzk_commission_amount")) {
      Object obj = map.get("kzk_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setKzkCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setKzkCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setKzkCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKzkCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setKzkCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_user_id")) {
      Object obj = map.get("service_user_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_amount")) {
      Object obj = map.get("service_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_commission_role")) {
      Object obj = map.get("service_commission_role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceCommissionRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("huabei_amount")) {
      Object obj = map.get("huabei_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setHuabeiAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setHuabeiAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setHuabeiAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHuabeiAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setHuabeiAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_outgoing_amount")) {
      Object obj = map.get("total_outgoing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalOutgoingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalOutgoingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalOutgoingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalOutgoingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalOutgoingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_status")) {
      Object obj = map.get("settlement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_amount")) {
      Object obj = map.get("settlement_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_time")) {
      Object obj = map.get("settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettlementTime(null);
      }
    }
    if(map.containsKey("gmt_settlement_time")) {
      Object obj = map.get("gmt_settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtSettlementTime(null);
      }
    }
    if(map.containsKey("settlement_rule")) {
      Object obj = map.get("settlement_rule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettlementRule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_channel")) {
      Object obj = map.get("account_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_id")) {
      Object obj = map.get("merchant_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMerchantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_remark")) {
      Object obj = map.get("order_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("czj_amount")) {
      Object obj = map.get("czj_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCzjAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_info")) {
      Object obj = map.get("refund_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefundInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount_detail")) {
      Object obj = map.get("other_amount_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOtherAmountDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mcn_id")) {
      Object obj = map.get("mcn_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMcnId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount_desc")) {
      Object obj = map.get("other_amount_desc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOtherAmountDesc((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOtherAmountDesc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOtherAmountDesc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOtherAmountDesc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOtherAmountDesc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_pay_market_allowance_amount")) {
      Object obj = map.get("platform_pay_market_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatformPayMarketAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatformPayMarketAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatformPayMarketAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_amount")) {
      Object obj = map.get("other_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOtherAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("collect_mode")) {
      Object obj = map.get("collect_mode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sale_return_status")) {
      Object obj = map.get("sale_return_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSaleReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_process_status")) {
      Object obj = map.get("check_process_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_order_no")) {
      Object obj = map.get("check_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_flag")) {
      Object obj = map.get("recogn_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setRecognFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecognFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("recogn_item")) {
      Object obj = map.get("recogn_item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_order_id")) {
      Object obj = map.get("recogn_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_refund_id")) {
      Object obj = map.get("recogn_refund_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognRefundId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognAmount")) {
      Object obj = map.get("recognAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRecognAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRecognAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRecognAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecognAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRecognAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIncomeType((String)obj);
        }
      } else{
      }
    }
  }
}
