package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sales_order_check_result_history
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesOrderCheckResultHistory implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 对账结果id
   */
  private Long checkResultId;
  /**
   * 电商销售订单id
   */
  private Long orderId;
  /**
   * 电商销售订单编号
   */
  private String orderNo;
  /**
   * OMS订单id
   */
  private String omsOrderId;
  /**
   * OMS订单编号
   */
  private String omsOrderNo;
  /**
   * 对账差异金额
   */
  private BigDecimal checkDiffAmount;
  /**
   * 对账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;
  /**
   * 应收订单id
   */
  private Long receivableOrderId;
  /**
   * 应收订单编号
   */
  private String receivableOrderNo;
  /**
   * 应收订单创建日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receivableOrderCreateTime;
  /**
   * 应收订单作废状态
   */
  private String receivableCancelStatus;
  /**
   * 对账操作人id
   */
  private Long checkUserId;
  /**
   * 对账操作人名称
   */
  private String checkUserName;
  /**
   * 应收订单操作人id
   */
  private Long receivableUserId;
  /**
   * 应收订单操作人名称
   */
  private String receivableUserName;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;

  /**
   * 对一关联关系 关联对象 salesOrderCheckResult
   */
  private Long fourIdId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("check_result_id", checkResultId);
      map.put("order_id", orderId);
      map.put("order_no", orderNo);
      map.put("oms_order_id", omsOrderId);
      map.put("oms_order_no", omsOrderNo);
      map.put("check_diff_amount", checkDiffAmount);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("receivable_order_id", receivableOrderId);
      map.put("receivable_order_no", receivableOrderNo);
      map.put("receivable_order_create_time", BocpGenUtils.toTimestamp(receivableOrderCreateTime));
      map.put("receivable_cancel_status", receivableCancelStatus);
      map.put("check_user_id", checkUserId);
      map.put("check_user_name", checkUserName);
      map.put("receivable_user_id", receivableUserId);
      map.put("receivable_user_name", receivableUserName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      map.put("fourId.id", fourIdId);
      return map;
  }

  public static SalesOrderCheckResultHistory fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesOrderCheckResultHistory entity = new SalesOrderCheckResultHistory();

    if(map.containsKey("check_result_id")) {
      Object obj = map.get("check_result_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckResultId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckResultId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckResultId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_order_id")) {
      Object obj = map.get("oms_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_order_no")) {
      Object obj = map.get("oms_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("receivable_order_id")) {
      Object obj = map.get("receivable_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setReceivableOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_no")) {
      Object obj = map.get("receivable_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_create_time")) {
      Object obj = map.get("receivable_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceivableOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceivableOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_cancel_status")) {
      Object obj = map.get("receivable_cancel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableCancelStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_user_id")) {
      Object obj = map.get("receivable_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceivableUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setReceivableUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_user_name")) {
      Object obj = map.get("receivable_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("fourId.id")) {
       Object obj = map.get("fourId.id");
       if(obj instanceof Long) {
         entity.setFourIdId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setFourIdId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("check_result_id")) {
      Object obj = map.get("check_result_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckResultId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckResultId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckResultId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_order_id")) {
      Object obj = map.get("oms_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOmsOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_order_no")) {
      Object obj = map.get("oms_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOmsOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("receivable_order_id")) {
      Object obj = map.get("receivable_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceivableOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setReceivableOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_no")) {
      Object obj = map.get("receivable_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceivableOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_create_time")) {
      Object obj = map.get("receivable_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceivableOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceivableOrderCreateTime(null);
      }
    }
    if(map.containsKey("receivable_cancel_status")) {
      Object obj = map.get("receivable_cancel_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceivableCancelStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_user_id")) {
      Object obj = map.get("receivable_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceivableUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setReceivableUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_user_name")) {
      Object obj = map.get("receivable_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceivableUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("fourId.id")) {
    Object obj = map.get("fourId.id");
    if(obj instanceof Long) {
        this.setFourIdId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setFourIdId(Long.parseLong((String)obj));
    }
  }
  }
}
