package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * account_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum AccountType {

    _0("0", "记账"),
    _1("1", "冲销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountType fromCode(String code) {
        return Stream.of(AccountType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
