package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_result
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum CheckResult {

    _0("0", "允差外不通过"),
    _1("1", "允差内通过"),
    _2("2", "未找到电商订单"),
    _3("3", "未找到OMS订单"),
    _4("4", "未找到应收订单"),
    _5("5", "未找到结算单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckResult fromCode(String code) {
        return Stream.of(CheckResult.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
