package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DataType {

    AA("aa", "单据类型1"),
    BB("bb", "单据类型2");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataType fromCode(String code) {
        return Stream.of(DataType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
