package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_aftersale_sub_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DyAftersaleSubType {

    _8001("8001", "以换代修"),
    _0("0", "default");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyAftersaleSubType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAftersaleSubType fromCode(String code) {
        return Stream.of(DyAftersaleSubType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
