package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_order_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DyCheckOrderType {

    _0("0", "普通订单"),
    _1("1", "定金(已退款)"),
    _2("2", "定金(尾款已支付)"),
    _3("3", "定金(尾款未支付)"),
    _4("4", "尾款(尾款已支付)"),
    _5("5", "尾款(已退款)");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckOrderType fromCode(String code) {
        return Stream.of(DyCheckOrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
