package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_trans_scene_tag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DyCheckTransSceneTag {

    _0("0", "其他"),
    _1("1", "消费者赔付"),
    _2("2", "小额打款"),
    _3("3", "判罚扣款"),
    _4("4", "物流赔付"),
    _5("5", "充值保证金");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckTransSceneTag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckTransSceneTag fromCode(String code) {
        return Stream.of(DyCheckTransSceneTag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
