package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_order_statys
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DyOrderStatys {

    _1("1", "待确认/待支付"),
    _2("2", "备货中"),
    _3("3", "已发货（全部发货）"),
    _4("4", "已取消"),
    _5("5", "已完成（已收货）"),
    _101("101", "部分发货"),
    _105("105", "已支付"),
    _6("6", "-"),
    _102("102", "-"),
    _103("103", "-"),
    _104("104", "-");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyOrderStatys(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyOrderStatys fromCode(String code) {
        return Stream.of(DyOrderStatys.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
