package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_settlement_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum DySettlementType {

    _0("0", "已结算"),
    _1("1", "结算后退款-原路退回"),
    _2("2", "保证金退款-支出退回"),
    _3("3", "结算后退款-非原路退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DySettlementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DySettlementType fromCode(String code) {
        return Stream.of(DySettlementType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
