package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum EcChannel {

    TM("TM", "天猫"),
    JD("JD", "京东"),
    PDD("PDD", "拼多多"),
    DY("DY", "抖音"),
    KS("KS", "快手");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EcChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcChannel fromCode(String code) {
        return Stream.of(EcChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
