package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_trade_from
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum JkyTradeFrom {

    _1("1", "网店下载"),
    _2("2", "手工新建"),
    _3("3", "订单导入"),
    _4("4", "吉商城"),
    _7("7", "门店"),
    _8("8", "分销"),
    _9("9", "吉链采购"),
    _10("10", "吉链分销"),
    _11("11", "吉商城分销"),
    _12("12", "奇门分销"),
    _13("13", "销售返利"),
    _14("14", "门店补货"),
    _6("6", "售后");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyTradeFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyTradeFrom fromCode(String code) {
        return Stream.of(JkyTradeFrom.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
