package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_receipt_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum KsReceiptStatus {

    _0("0", "未知"),
    _1("1", "未收到货"),
    _2("2", "已收到货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsReceiptStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsReceiptStatus fromCode(String code) {
        return Stream.of(KsReceiptStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
