package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * kshandling_way
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum KshandlingWay {

    _1("1", "退货退款"),
    _10("10", "仅退款"),
    _3("3", "换货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KshandlingWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KshandlingWay fromCode(String code) {
        return Stream.of(KshandlingWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
