package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_after_sale_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum OmsAfterSaleTradeStatus {

    _0("0", "待收货"),
    _1("1", "待结算"),
    _2("2", "被取消"),
    _3("3", "已完成"),
    _4("4", "待审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OmsAfterSaleTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsAfterSaleTradeStatus fromCode(String code) {
        return Stream.of(OmsAfterSaleTradeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
