package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_group_role
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum PddGroupRole {

    _0("0", "团员"),
    _1("1", "团长");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddGroupRole(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddGroupRole fromCode(String code) {
        return Stream.of(PddGroupRole.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
