package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_order_control_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum PddOrderControlStatus {

    _0("0", "正常订单"),
    _1("1", "审核中订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddOrderControlStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddOrderControlStatus fromCode(String code) {
        return Stream.of(PddOrderControlStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
