package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_stock_out_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum PddStockOutHandleStatus {

    __1("-1", "无缺货处理"),
    _0("0", "缺货待处理"),
    _1("1", "缺货已处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddStockOutHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddStockOutHandleStatus fromCode(String code) {
        return Stream.of(PddStockOutHandleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
