package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * platform_subsidy_deal_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public enum PlatformSubsidyDealStatus {

    _0("0", "草稿"),
    _1("1", "已提交"),
    _2("2", "回传中"),
    _3("3", "已记账"),
    _4("4", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PlatformSubsidyDealStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PlatformSubsidyDealStatus fromCode(String code) {
        return Stream.of(PlatformSubsidyDealStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
