package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * dy_settlement
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DySettlement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键
   */
  private Long dyId;
  /**
   * 租户code
   */
  private String dyTenantCode;
  /**
   * 店铺id
   */
  private String storeId;
  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;
  /**
   * 结算时间
   */
  private String settleTime;
  /**
   * 结算单号
   */
  private String requestNo;
  /**
   * 订单号
   */
  private String shopOrderId;
  /**
   * 子订单号
   */
  private String orderId;
  /**
   * 结算金额
   */
  private BigDecimal settleAmount;
  /**
   * 货款结算对应的账户类型
   */
  private String payTypeDesc;
  /**
   * 是否包含结算前退款
   */
  private Boolean isContainsRefundBeforeSettle;
  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;
  /**
   * 商品id
   */
  private String productId;
  /**
   * 商品数量
   */
  private Long goodsCount;
  /**
   * 业务类型
   */
  private String flowTypeDesc;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 订单总价
   */
  private BigDecimal totalAmount;
  /**
   * 商品总价
   */
  private BigDecimal totalGoodsAmount;
  /**
   * 运费
   */
  private BigDecimal postAmount;
  /**
   * 店铺券
   */
  private BigDecimal shopCoupon;
  /**
   * 结算前退款金额
   */
  private BigDecimal refundBeforeSettle;
  /**
   * 平台补贴
   */
  private BigDecimal platformCoupon;
  /**
   * 达人补贴
   */
  private BigDecimal authorCoupon;
  /**
   * 抖音支付补贴
   */
  private BigDecimal ztPayPromotion;
  /**
   * DOU分期营销补贴
   */
  private BigDecimal zrPayPromotion;
  /**
   * 用户实付
   */
  private BigDecimal realPayAmount;
  /**
   * 收入合计
   */
  private BigDecimal totalIncome;
  /**
   * 平台服务费
   */
  private BigDecimal platformServiceFee;
  /**
   * 佣金
   */
  private BigDecimal commission;
  /**
   * 渠道分成
   */
  private BigDecimal goodLearnChannelFee;
  /**
   * 团长服务费
   */
  private BigDecimal colonelServiceFee;
  /**
   * 直播间站外推广
   */
  private BigDecimal channelPromotionFee;
  /**
   * 其他分成
   */
  private BigDecimal otherSharingAmount;
  /**
   * 合计支出
   */
  private BigDecimal totalOutcome;
  /**
   * 备注
   */
  private String remark;
  /**
   * 打包费
   */
  private BigDecimal packingAmount;
  /**
   * 是否免佣
   */
  private Boolean freeCommissionFlag;
  /**
   * 免佣金额
   */
  private BigDecimal realFreeCommissionAmount;
  /**
   * 服务商佣金
   */
  private BigDecimal partnerCommission;
  /**
   * 以旧换新抵扣
   */
  private BigDecimal oldForNewPromotion;
  /**
   * 银行补贴
   */
  private BigDecimal bankPromotion;
  /**
   * 平台补贴运费
   */
  private BigDecimal postPromotionAmount;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 单据流转处理状态
   */
  private String dealStatus;
  /**
   * 业务ID
   */
  private String businessId;
  /**
   * 数据MD5
   */
  private String dataMD5;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 最新版本
   */
  private Boolean latest;
  /**
   * 店铺id
   */
  private String shopId;
  /**
   * 账户信息
   */
  private String accountInfo;
  /**
   * 项目
   */
  private String itemName;
  /**
   * 金额
   */
  private String amount;
  /**
   * 类型
   */
  private String type;
  /**
   * esb客户id
   */
  private String esbId;
  /**
   * esb客户名
   */
  private String esbName;
  /**
   * 电商订单号
   */
  private String orderNo;
  /**
   * 识别状态
   */
  private String recognitionStatus;
  /**
   * 店铺名称
   */
  private String shopName;
  /**
   * 事业部名称
   */
  private String bussinessUnitName;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司税号
   */
  private String companyTaxNo;
  /**
   * 对账金额
   */
  private BigDecimal checkAmount;
  /**
   * 销退类型
   */
  private String saleReturnStatus;
  /**
   * 账期
   */
  private String accountPeriod;
  /**
   * 账单处理状态
   */
  private String checkProcessStatus;
  /**
   * 对账订单号
   */
  private String checkOrderNo;
  /**
   * 识别标识
   */
  private Boolean recognFlag;
  /**
   * 项目-识别
   */
  private String recognItem;
  /**
   * 识别订单号
   */
  private String recognOrderId;
  /**
   * 退款订单号
   */
  private String recognRefundId;
  /**
   * 识别金额
   */
  private BigDecimal recognAmount;
  /**
   * 入账类型
   */
  private String incomeType;
  /**
   * 结算单类型
   */
  private String tradeType;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("dy_id", dyId);
      map.put("dy_tenant_code", dyTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("settle_time", settleTime);
      map.put("request_no", requestNo);
      map.put("shop_order_id", shopOrderId);
      map.put("order_id", orderId);
      map.put("settle_amount", settleAmount);
      map.put("pay_type_desc", payTypeDesc);
      map.put("is_contains_refund_before_settle", isContainsRefundBeforeSettle);
      map.put("order_time", BocpGenUtils.toTimestamp(orderTime));
      map.put("product_id", productId);
      map.put("goods_count", goodsCount);
      map.put("flow_type_desc", flowTypeDesc);
      map.put("order_type", orderType);
      map.put("total_amount", totalAmount);
      map.put("total_goods_amount", totalGoodsAmount);
      map.put("post_amount", postAmount);
      map.put("shop_coupon", shopCoupon);
      map.put("refund_before_settle", refundBeforeSettle);
      map.put("platform_coupon", platformCoupon);
      map.put("author_coupon", authorCoupon);
      map.put("zt_pay_promotion", ztPayPromotion);
      map.put("zr_pay_promotion", zrPayPromotion);
      map.put("real_pay_amount", realPayAmount);
      map.put("total_income", totalIncome);
      map.put("platform_service_fee", platformServiceFee);
      map.put("commission", commission);
      map.put("good_learn_channel_fee", goodLearnChannelFee);
      map.put("colonel_service_fee", colonelServiceFee);
      map.put("channel_promotion_fee", channelPromotionFee);
      map.put("other_sharing_amount", otherSharingAmount);
      map.put("total_outcome", totalOutcome);
      map.put("remark", remark);
      map.put("packing_amount", packingAmount);
      map.put("free_commission_flag", freeCommissionFlag);
      map.put("real_free_commission_amount", realFreeCommissionAmount);
      map.put("partner_commission", partnerCommission);
      map.put("old_for_new_promotion", oldForNewPromotion);
      map.put("bank_promotion", bankPromotion);
      map.put("post_promotion_amount", postPromotionAmount);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("checkStatus", checkStatus);
      map.put("latest", latest);
      map.put("shop_id", shopId);
      map.put("account_info", accountInfo);
      map.put("item_name", itemName);
      map.put("amount", amount);
      map.put("type", type);
      map.put("esb_id", esbId);
      map.put("esb_name", esbName);
      map.put("order_no", orderNo);
      map.put("recognition_status", recognitionStatus);
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("check_amount", checkAmount);
      map.put("sale_return_status", saleReturnStatus);
      map.put("account_period", accountPeriod);
      map.put("check_process_status", checkProcessStatus);
      map.put("check_order_no", checkOrderNo);
      map.put("recogn_flag", recognFlag);
      map.put("recogn_item", recognItem);
      map.put("recogn_order_id", recognOrderId);
      map.put("recogn_refund_id", recognRefundId);
      map.put("recognAmount", recognAmount);
      map.put("incomeType", incomeType);
      map.put("trade_type", tradeType);

      return map;
  }

  public static DySettlement fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    DySettlement entity = new DySettlement();

    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_tenant_code")) {
      Object obj = map.get("dy_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDyTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("settle_time")) {
      Object obj = map.get("settle_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettleTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_no")) {
      Object obj = map.get("request_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_order_id")) {
      Object obj = map.get("shop_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settle_amount")) {
      Object obj = map.get("settle_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_type_desc")) {
      Object obj = map.get("pay_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_contains_refund_before_settle")) {
      Object obj = map.get("is_contains_refund_before_settle");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsContainsRefundBeforeSettle((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsContainsRefundBeforeSettle(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_count")) {
      Object obj = map.get("goods_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodsCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGoodsCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("flow_type_desc")) {
      Object obj = map.get("flow_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_goods_amount")) {
      Object obj = map.get("total_goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_coupon")) {
      Object obj = map.get("shop_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShopCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShopCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShopCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShopCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShopCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_before_settle")) {
      Object obj = map.get("refund_before_settle");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundBeforeSettle((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundBeforeSettle(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundBeforeSettle(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_coupon")) {
      Object obj = map.get("platform_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("author_coupon")) {
      Object obj = map.get("author_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthorCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthorCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthorCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthorCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthorCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zt_pay_promotion")) {
      Object obj = map.get("zt_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZtPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZtPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZtPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZtPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZtPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zr_pay_promotion")) {
      Object obj = map.get("zr_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZrPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZrPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZrPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZrPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZrPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("real_pay_amount")) {
      Object obj = map.get("real_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_income")) {
      Object obj = map.get("total_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_service_fee")) {
      Object obj = map.get("platform_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("good_learn_channel_fee")) {
      Object obj = map.get("good_learn_channel_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodLearnChannelFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodLearnChannelFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodLearnChannelFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("colonel_service_fee")) {
      Object obj = map.get("colonel_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setColonelServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setColonelServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setColonelServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("channel_promotion_fee")) {
      Object obj = map.get("channel_promotion_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChannelPromotionFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChannelPromotionFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannelPromotionFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("other_sharing_amount")) {
      Object obj = map.get("other_sharing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherSharingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherSharingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherSharingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_outcome")) {
      Object obj = map.get("total_outcome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalOutcome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalOutcome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalOutcome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalOutcome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalOutcome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packing_amount")) {
      Object obj = map.get("packing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("free_commission_flag")) {
      Object obj = map.get("free_commission_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFreeCommissionFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeCommissionFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("real_free_commission_amount")) {
      Object obj = map.get("real_free_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealFreeCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealFreeCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("partner_commission")) {
      Object obj = map.get("partner_commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPartnerCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPartnerCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPartnerCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPartnerCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPartnerCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("old_for_new_promotion")) {
      Object obj = map.get("old_for_new_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOldForNewPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOldForNewPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOldForNewPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOldForNewPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOldForNewPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bank_promotion")) {
      Object obj = map.get("bank_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBankPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBankPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBankPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBankPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBankPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_info")) {
      Object obj = map.get("account_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("esb_id")) {
      Object obj = map.get("esb_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEsbId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("esb_name")) {
      Object obj = map.get("esb_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEsbName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognition_status")) {
      Object obj = map.get("recognition_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognitionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sale_return_status")) {
      Object obj = map.get("sale_return_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSaleReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_process_status")) {
      Object obj = map.get("check_process_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_order_no")) {
      Object obj = map.get("check_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_flag")) {
      Object obj = map.get("recogn_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRecognFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecognFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("recogn_item")) {
      Object obj = map.get("recogn_item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_order_id")) {
      Object obj = map.get("recogn_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_refund_id")) {
      Object obj = map.get("recogn_refund_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecognRefundId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognAmount")) {
      Object obj = map.get("recognAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRecognAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRecognAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRecognAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecognAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecognAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_tenant_code")) {
      Object obj = map.get("dy_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDyTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("settle_time")) {
      Object obj = map.get("settle_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSettleTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("request_no")) {
      Object obj = map.get("request_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_order_id")) {
      Object obj = map.get("shop_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settle_amount")) {
      Object obj = map.get("settle_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSettleAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSettleAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSettleAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSettleAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSettleAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_type_desc")) {
      Object obj = map.get("pay_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_contains_refund_before_settle")) {
      Object obj = map.get("is_contains_refund_before_settle");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsContainsRefundBeforeSettle((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsContainsRefundBeforeSettle(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("order_time")) {
      Object obj = map.get("order_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOrderTime(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_count")) {
      Object obj = map.get("goods_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGoodsCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGoodsCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGoodsCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("flow_type_desc")) {
      Object obj = map.get("flow_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFlowTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_goods_amount")) {
      Object obj = map.get("total_goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_coupon")) {
      Object obj = map.get("shop_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setShopCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setShopCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setShopCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShopCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setShopCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_before_settle")) {
      Object obj = map.get("refund_before_settle");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRefundBeforeSettle((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRefundBeforeSettle(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRefundBeforeSettle(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundBeforeSettle(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRefundBeforeSettle(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_coupon")) {
      Object obj = map.get("platform_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatformCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatformCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatformCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatformCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatformCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("author_coupon")) {
      Object obj = map.get("author_coupon");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAuthorCoupon((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAuthorCoupon(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAuthorCoupon(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthorCoupon(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAuthorCoupon(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zt_pay_promotion")) {
      Object obj = map.get("zt_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setZtPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setZtPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setZtPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZtPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setZtPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zr_pay_promotion")) {
      Object obj = map.get("zr_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setZrPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setZrPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setZrPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZrPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setZrPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("real_pay_amount")) {
      Object obj = map.get("real_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRealPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRealPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRealPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRealPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRealPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_income")) {
      Object obj = map.get("total_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_service_fee")) {
      Object obj = map.get("platform_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPlatformServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPlatformServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPlatformServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPlatformServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPlatformServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("good_learn_channel_fee")) {
      Object obj = map.get("good_learn_channel_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGoodLearnChannelFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGoodLearnChannelFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGoodLearnChannelFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGoodLearnChannelFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGoodLearnChannelFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("colonel_service_fee")) {
      Object obj = map.get("colonel_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setColonelServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setColonelServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setColonelServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setColonelServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setColonelServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("channel_promotion_fee")) {
      Object obj = map.get("channel_promotion_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setChannelPromotionFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setChannelPromotionFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setChannelPromotionFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setChannelPromotionFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setChannelPromotionFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("other_sharing_amount")) {
      Object obj = map.get("other_sharing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOtherSharingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOtherSharingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOtherSharingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOtherSharingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOtherSharingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_outcome")) {
      Object obj = map.get("total_outcome");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalOutcome((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalOutcome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalOutcome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalOutcome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalOutcome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packing_amount")) {
      Object obj = map.get("packing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPackingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPackingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPackingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPackingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPackingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("free_commission_flag")) {
      Object obj = map.get("free_commission_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setFreeCommissionFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFreeCommissionFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("real_free_commission_amount")) {
      Object obj = map.get("real_free_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRealFreeCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRealFreeCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRealFreeCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRealFreeCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRealFreeCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("partner_commission")) {
      Object obj = map.get("partner_commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPartnerCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPartnerCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPartnerCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPartnerCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPartnerCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("old_for_new_promotion")) {
      Object obj = map.get("old_for_new_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOldForNewPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOldForNewPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOldForNewPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOldForNewPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOldForNewPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bank_promotion")) {
      Object obj = map.get("bank_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBankPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBankPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBankPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBankPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBankPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_info")) {
      Object obj = map.get("account_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("esb_id")) {
      Object obj = map.get("esb_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEsbId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("esb_name")) {
      Object obj = map.get("esb_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEsbName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognition_status")) {
      Object obj = map.get("recognition_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognitionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sale_return_status")) {
      Object obj = map.get("sale_return_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSaleReturnStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_process_status")) {
      Object obj = map.get("check_process_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_order_no")) {
      Object obj = map.get("check_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_flag")) {
      Object obj = map.get("recogn_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setRecognFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecognFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("recogn_item")) {
      Object obj = map.get("recogn_item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_order_id")) {
      Object obj = map.get("recogn_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogn_refund_id")) {
      Object obj = map.get("recogn_refund_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecognRefundId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recognAmount")) {
      Object obj = map.get("recognAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRecognAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRecognAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRecognAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecognAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRecognAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeType((String)obj);
        }
      } else{
      }
    }
  }
}
