package com.xforceplus.ultraman.app.policymanagement.metadata.validator;

import com.xforceplus.ultraman.app.policymanagement.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.policymanagement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-12-13
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PluginCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PluginCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PluginCode.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResultType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ResultType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ResultType.class.getSimpleName());
            }
        }
        if(clazz.equals(FailedContinue.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FailedContinue.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FailedContinue.class.getSimpleName());
            }
        }
        if(clazz.equals(TbSalesOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TbSalesOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TbSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddAfterSalesStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddAfterSalesStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddAfterSalesStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupRole.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddGroupRole.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddGroupRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddGroupStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddGroupStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddHomeDeliveryType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddHomeDeliveryType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddHomeDeliveryType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddIsLuckyFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddIsLuckyFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddIsLuckyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PddKktBizType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddKktBizType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddKktBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderControlStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddOrderControlStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddOrderControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddShippingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddShippingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddShippingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddStockOutHandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddStockOutHandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddStockOutHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddTradeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddTradeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderTypes.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyOrderTypes.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyOrderTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderStatys.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyOrderStatys.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyOrderStatys.class.getSimpleName());
            }
        }
        if(clazz.equals(DyPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCpsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCpsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCpsType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCoType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCoType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCoType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyTradeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyTradeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyGoodsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyGoodsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsTradeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OmsTradeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OmsTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EcChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EcChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillChangeRecordSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillChangeRecordSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillChangeRecordSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyPayType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyTradeFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyTradeFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyPayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyPayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyTradeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyIsBillCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyIsBillCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyIsBillCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyLogisticType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JkyLogisticType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JkyLogisticType.class.getSimpleName());
            }
        }
        if(clazz.equals(DealStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DealStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DealStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EbsBackStauts.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EbsBackStauts.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EbsBackStauts.class.getSimpleName());
            }
        }
        if(clazz.equals(PddRefundOperatorRole.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddRefundOperatorRole.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddRefundOperatorRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddUserShippingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PddUserShippingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PddUserShippingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyAfterSaleOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyAfterSaleOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyAfterSaleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyAfterSaleType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleRefundType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyAfterSaleRefundType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyAfterSaleRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyRefundType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyRefundType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyArbitrateStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyArbitrateStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyArbitrateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyRefundStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyRefundStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyRefundStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyIsAgreeRefuseSign.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyIsAgreeRefuseSign.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyIsAgreeRefuseSign.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAftersaleSubType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyAftersaleSubType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyAftersaleSubType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleDetilOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyAfterSaleDetilOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyAfterSaleDetilOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DySettlementType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DySettlementType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DySettlementType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpReturnStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErpReturnStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErpReturnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValidStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ValidStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ValidStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SumOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SumOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SumOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCollectMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCollectMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCollectMode.class.getSimpleName());
            }
        }
        if(clazz.equals(KsSettlementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsSettlementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsSettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsAfterSaleTradeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OmsAfterSaleTradeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OmsAfterSaleTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsAfterSaleReturnType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OmsAfterSaleReturnType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OmsAfterSaleReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckFundFlow.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckFundFlow.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckFundFlow.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckAccountBillDescTag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckAccountBillDescTag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckAccountBillDescTag.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckBizType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckBizType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckAccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckAccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckAccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckTransSceneTag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DyCheckTransSceneTag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DyCheckTransSceneTag.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCheckInOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsCheckInOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsCheckInOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SyncOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SyncOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableSalesOrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableSalesOrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteOffStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteOffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(CollectionOrderType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CollectionOrderType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CollectionOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentsType.class.getSimpleName());
            }
        }
        if(clazz.equals(EbsDocumentsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EbsDocumentsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EbsDocumentsType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessGroup.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessGroup.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentLabel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentLabel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentLabel.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AmountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AmountType.class.getSimpleName());
            }
        }
        if(clazz.equals(DefaultPrice.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DefaultPrice.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DefaultPrice.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsPrice.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsPrice.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsPrice.class.getSimpleName());
            }
        }
        if(clazz.equals(GiftType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GiftType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GiftType.class.getSimpleName());
            }
        }
        if(clazz.equals(PositiveNegative.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PositiveNegative.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PositiveNegative.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckErpBackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckErpBackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckErpBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckResult.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckResult.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckResult.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfirmStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableBusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceivableBusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceivableBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExistence.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceExistence.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceExistence.class.getSimpleName());
            }
        }
        if(clazz.equals(RecognitionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecognitionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecognitionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteoffStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteoffStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteoffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsVirtual.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsVirtual.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsVirtual.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleReturnStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SaleReturnStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SaleReturnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataResourceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataResourceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataResourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsChannel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OmsChannel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OmsChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(KshandlingWay.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KshandlingWay.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KshandlingWay.class.getSimpleName());
            }
        }
        if(clazz.equals(KsnegotiateStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsnegotiateStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsnegotiateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Ksrefundstatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Ksrefundstatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Ksrefundstatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsReceiptStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsReceiptStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DoubleCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DoubleCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DoubleCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractDebtFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ContractDebtFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ContractDebtFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PlatformSubsidyDealStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PlatformSubsidyDealStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PlatformSubsidyDealStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
