package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * create_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum CreateType {

    _0("0", "系统预制"),
    _1("1", "自定义");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CreateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CreateType fromCode(String code) {
        return Stream.of(CreateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
