package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_resource_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum DataResourceType {

    _0("0", "系统"),
    _1("1", "导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataResourceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataResourceType fromCode(String code) {
        return Stream.of(DataResourceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
