package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * double_check_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum DoubleCheckStatus {

    _0("0", "未复核"),
    _1("1", "已复核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DoubleCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DoubleCheckStatus fromCode(String code) {
        return Stream.of(DoubleCheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
