package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_after_sale_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum DyAfterSaleType {

    _3("3", "换货待买家收货"),
    _6("6", "待商家同意"),
    _7("7", "待买家退货"),
    _8("8", "待商家发货"),
    _11("11", "待商家二次同意"),
    _12("12", "售后成功"),
    _14("14", "换货成功"),
    _27("27", "商家一次拒绝"),
    _28("28", "售后失败"),
    _29("29", "商家二次拒绝");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyAfterSaleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAfterSaleType fromCode(String code) {
        return Stream.of(DyAfterSaleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
