package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_arbitrate_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum DyArbitrateStatus {

    _0("0", "无仲裁记录"),
    _1("1", "仲裁中"),
    _2("2", "客服同意"),
    _3("3", "客服拒绝"),
    _4("4", "待商家举证"),
    _5("5", "协商期"),
    _255("255", "仲裁结束");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyArbitrateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyArbitrateStatus fromCode(String code) {
        return Stream.of(DyArbitrateStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
