package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum JkyInvoiceType {

    _0("0", "无"),
    _1("1", "增值税电子普通发票"),
    _2("2", "增值税普通发票"),
    _3("3", "增值税专用发票"),
    _4("4", "增值税电子专用发票"),
    _5("5", "普通发票（全电）"),
    _6("6", "专用发票（全电）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyInvoiceType fromCode(String code) {
        return Stream.of(JkyInvoiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
