package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_is_bill_check
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum JkyIsBillCheck {

    _1("1", "对账"),
    其他("其他", "未对账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyIsBillCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyIsBillCheck fromCode(String code) {
        return Stream.of(JkyIsBillCheck.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
