package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_collect_mode
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum KsCollectMode {

    _1("1", "普通订单：直付给分销者"),
    _2("2", "聚力订单：平台计收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsCollectMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsCollectMode fromCode(String code) {
        return Stream.of(KsCollectMode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
