package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_after_sale_return_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum OmsAfterSaleReturnType {

    退("退", "只有退货"),
    换("换", "有换货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OmsAfterSaleReturnType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsAfterSaleReturnType fromCode(String code) {
        return Stream.of(OmsAfterSaleReturnType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
