package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_group_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum PddGroupStatus {

    _0("0", "拼团中"),
    _1("1", "已成团"),
    _2("2", "团失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddGroupStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddGroupStatus fromCode(String code) {
        return Stream.of(PddGroupStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
