package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_home_delivery_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum PddHomeDeliveryType {

    _0("0", "不支持送货"),
    _1("1", "送货入户不安装"),
    _2("2", "送货入户并安装");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddHomeDeliveryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddHomeDeliveryType fromCode(String code) {
        return Stream.of(PddHomeDeliveryType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
