package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_is_lucky_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
public enum PddIsLuckyFlag {

    _1("1", "非抽奖订单"),
    _2("2", "抽奖订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddIsLuckyFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddIsLuckyFlag fromCode(String code) {
        return Stream.of(PddIsLuckyFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
