package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ks_sales_order
 * </p>
 *
 * @author ultraman
 * @since 2024-12-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsSalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 快手ID
   */
  private Long ksId;
  /**
   * 租户code
   */
  private String ksTenantCode;
  /**
   * 店铺编号
   */
  private String shopId;
  /**
   * 买家图像
   */
  private String buyerImage;
  /**
   * 买家id
   */
  private String buyerOpenId;
  /**
   * 买家昵称
   */
  private String buyerNick;
  /**
   * 卖家id
   */
  private String sellerOpenId;
  /**
   * 卖家昵称
   */
  private String sellerNick;
  /**
   * 运费
   */
  private BigDecimal expressFee;
  /**
   * 折扣价格
   */
  private BigDecimal discountFee;
  /**
   * 子订单商品总价
   */
  private BigDecimal totalFee;
  /**
   * 订单状态
   */
  private String status;
  /**
   * 买家留言
   */
  private String remark;
  /**
   * 发货超时间隔时间
   */
  private Long theDayOfDeliverGoodsTime;
  /**
   * 订单支付时间+承诺发货时间间隔
   */
  private Long promiseTimeStampOfDelivery;
  /**
   * 订单活动类型标
   */
  private Long activityType;
  /**
   * 商家承诺发货时间
   */
  private Long validPromiseShipmentTimeStamp;
  /**
   * 库存预售
   */
  private Boolean preSale;
  /**
   * 评价状态
   */
  private Boolean commentStatus;
  /**
   * 风险Code码
   */
  private Long riskCode;
  /**
   * 支付方式
   */
  private String payChannel;
  /**
   * 商家报备审核后的发货时间
   */
  private Long sellerDelayPromiseTimeStamp;
  /**
   * 是否优先发货
   */
  private Boolean priorityDelivery;
  /**
   * 催发货次数
   */
  private Long remindShipmentSign;
  /**
   * 最近催发货时间戳
   */
  private Long remindShipmentTime;
  /**
   * 付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime myPayTime;
  /**
   * 退款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime myRefundTime;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 订单编号
   */
  private String oid;
  /**
   * 单据流转状态
   */
  private String dealStatus;
  /**
   * 发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendTime;
  /**
   * 发起退款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime refundTime;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ksCreateTime;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ksUpdateTime;
  /**
   * 业务ID
   */
  private String businessId;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 数据MD5
   */
  private String dataMD5;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * 对账金额
   */
  private BigDecimal checkAmount;
  /**
   * 付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payTime;
  /**
   * 店铺名称
   */
  private String shopName;
  /**
   * 事业部名称
   */
  private String bussinessUnitName;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司税号
   */
  private String companyTaxNo;
  /**
   * 最新版本
   */
  private Boolean latest;
  /**
   * 账期
   */
  private String accountPeriod;
  /**
   * 支付方式
   */
  private String payType;
  /**
   * 分销类型
   */
  private String cpsType;
  /**
   * 交易分类
   */
  private String coType;
  /**
   * 收货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime recvTime;
  /**
   * 组织树
   */
  private String orgTree;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ks_id", ksId);
      map.put("ks_tenant_code", ksTenantCode);
      map.put("shop_id", shopId);
      map.put("buyer_image", buyerImage);
      map.put("buyer_open_id", buyerOpenId);
      map.put("buyer_nick", buyerNick);
      map.put("seller_open_id", sellerOpenId);
      map.put("seller_nick", sellerNick);
      map.put("express_fee", expressFee);
      map.put("discount_fee", discountFee);
      map.put("total_fee", totalFee);
      map.put("status", status);
      map.put("remark", remark);
      map.put("theDayOfDeliverGoodsTime", theDayOfDeliverGoodsTime);
      map.put("promiseTimeStampOfDelivery", promiseTimeStampOfDelivery);
      map.put("activity_type", activityType);
      map.put("validPromiseShipmentTimeStamp", validPromiseShipmentTimeStamp);
      map.put("pre_sale", preSale);
      map.put("comment_status", commentStatus);
      map.put("risk_code", riskCode);
      map.put("pay_channel", payChannel);
      map.put("sellerDelayPromiseTimeStamp", sellerDelayPromiseTimeStamp);
      map.put("priority_delivery", priorityDelivery);
      map.put("remindShipmentSign", remindShipmentSign);
      map.put("remindShipmentTime", remindShipmentTime);
      map.put("my_pay_time", BocpGenUtils.toTimestamp(myPayTime));
      map.put("my_refund_time", BocpGenUtils.toTimestamp(myRefundTime));
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("oid", oid);
      map.put("deal_status", dealStatus);
      map.put("send_time", BocpGenUtils.toTimestamp(sendTime));
      map.put("refund_time", BocpGenUtils.toTimestamp(refundTime));
      map.put("ks_create_time", BocpGenUtils.toTimestamp(ksCreateTime));
      map.put("ks_update_time", BocpGenUtils.toTimestamp(ksUpdateTime));
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("check_amount", checkAmount);
      map.put("pay_time", BocpGenUtils.toTimestamp(payTime));
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("latest", latest);
      map.put("account_period", accountPeriod);
      map.put("pay_type", payType);
      map.put("cps_type", cpsType);
      map.put("co_type", coType);
      map.put("recv_time", BocpGenUtils.toTimestamp(recvTime));
      map.put("org_tree", orgTree);

      return map;
  }

  public static KsSalesOrder fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsSalesOrder entity = new KsSalesOrder();

    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_image")) {
      Object obj = map.get("buyer_image");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_open_id")) {
      Object obj = map.get("buyer_open_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_nick")) {
      Object obj = map.get("buyer_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_open_id")) {
      Object obj = map.get("seller_open_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("express_fee")) {
      Object obj = map.get("express_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExpressFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExpressFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExpressFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpressFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpressFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_fee")) {
      Object obj = map.get("total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("theDayOfDeliverGoodsTime")) {
      Object obj = map.get("theDayOfDeliverGoodsTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTheDayOfDeliverGoodsTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTheDayOfDeliverGoodsTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTheDayOfDeliverGoodsTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("promiseTimeStampOfDelivery")) {
      Object obj = map.get("promiseTimeStampOfDelivery");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPromiseTimeStampOfDelivery((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromiseTimeStampOfDelivery(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPromiseTimeStampOfDelivery(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("activity_type")) {
      Object obj = map.get("activity_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActivityType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setActivityType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("validPromiseShipmentTimeStamp")) {
      Object obj = map.get("validPromiseShipmentTimeStamp");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidPromiseShipmentTimeStamp((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setValidPromiseShipmentTimeStamp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setValidPromiseShipmentTimeStamp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pre_sale")) {
      Object obj = map.get("pre_sale");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPreSale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPreSale(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("comment_status")) {
      Object obj = map.get("comment_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCommentStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommentStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("risk_code")) {
      Object obj = map.get("risk_code");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiskCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiskCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRiskCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_channel")) {
      Object obj = map.get("pay_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerDelayPromiseTimeStamp")) {
      Object obj = map.get("sellerDelayPromiseTimeStamp");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSellerDelayPromiseTimeStamp((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerDelayPromiseTimeStamp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSellerDelayPromiseTimeStamp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("priority_delivery")) {
      Object obj = map.get("priority_delivery");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPriorityDelivery((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriorityDelivery(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("remindShipmentSign")) {
      Object obj = map.get("remindShipmentSign");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRemindShipmentSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemindShipmentSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRemindShipmentSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remindShipmentTime")) {
      Object obj = map.get("remindShipmentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRemindShipmentTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemindShipmentTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRemindShipmentTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("my_pay_time")) {
      Object obj = map.get("my_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMyPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMyPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMyPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMyPayTime(null);
      }
    }
    if(map.containsKey("my_refund_time")) {
      Object obj = map.get("my_refund_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMyRefundTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMyRefundTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMyRefundTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMyRefundTime(null);
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("send_time")) {
      Object obj = map.get("send_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendTime(null);
      }
    }
    if(map.containsKey("refund_time")) {
      Object obj = map.get("refund_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRefundTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRefundTime(null);
      }
    }
    if(map.containsKey("ks_create_time")) {
      Object obj = map.get("ks_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setKsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKsCreateTime(null);
      }
    }
    if(map.containsKey("ks_update_time")) {
      Object obj = map.get("ks_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setKsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKsUpdateTime(null);
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayTime(null);
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cps_type")) {
      Object obj = map.get("cps_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCpsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("co_type")) {
      Object obj = map.get("co_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recv_time")) {
      Object obj = map.get("recv_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRecvTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRecvTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecvTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRecvTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_image")) {
      Object obj = map.get("buyer_image");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_open_id")) {
      Object obj = map.get("buyer_open_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_nick")) {
      Object obj = map.get("buyer_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_open_id")) {
      Object obj = map.get("seller_open_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("express_fee")) {
      Object obj = map.get("express_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExpressFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExpressFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExpressFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExpressFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExpressFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_fee")) {
      Object obj = map.get("total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("theDayOfDeliverGoodsTime")) {
      Object obj = map.get("theDayOfDeliverGoodsTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTheDayOfDeliverGoodsTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTheDayOfDeliverGoodsTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTheDayOfDeliverGoodsTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("promiseTimeStampOfDelivery")) {
      Object obj = map.get("promiseTimeStampOfDelivery");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPromiseTimeStampOfDelivery((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPromiseTimeStampOfDelivery(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPromiseTimeStampOfDelivery(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("activity_type")) {
      Object obj = map.get("activity_type");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setActivityType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setActivityType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setActivityType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("validPromiseShipmentTimeStamp")) {
      Object obj = map.get("validPromiseShipmentTimeStamp");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setValidPromiseShipmentTimeStamp((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setValidPromiseShipmentTimeStamp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setValidPromiseShipmentTimeStamp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pre_sale")) {
      Object obj = map.get("pre_sale");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPreSale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPreSale(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("comment_status")) {
      Object obj = map.get("comment_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setCommentStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCommentStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("risk_code")) {
      Object obj = map.get("risk_code");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiskCode((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiskCode(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRiskCode(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pay_channel")) {
      Object obj = map.get("pay_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerDelayPromiseTimeStamp")) {
      Object obj = map.get("sellerDelayPromiseTimeStamp");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSellerDelayPromiseTimeStamp((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellerDelayPromiseTimeStamp(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSellerDelayPromiseTimeStamp(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("priority_delivery")) {
      Object obj = map.get("priority_delivery");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPriorityDelivery((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriorityDelivery(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("remindShipmentSign")) {
      Object obj = map.get("remindShipmentSign");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRemindShipmentSign((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRemindShipmentSign(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRemindShipmentSign(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remindShipmentTime")) {
      Object obj = map.get("remindShipmentTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRemindShipmentTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRemindShipmentTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRemindShipmentTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("my_pay_time")) {
      Object obj = map.get("my_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMyPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setMyPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMyPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setMyPayTime(null);
      }
    }
    if(map.containsKey("my_refund_time")) {
      Object obj = map.get("my_refund_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMyRefundTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setMyRefundTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMyRefundTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setMyRefundTime(null);
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("send_time")) {
      Object obj = map.get("send_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSendTime(null);
      }
    }
    if(map.containsKey("refund_time")) {
      Object obj = map.get("refund_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRefundTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRefundTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefundTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRefundTime(null);
      }
    }
    if(map.containsKey("ks_create_time")) {
      Object obj = map.get("ks_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setKsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setKsCreateTime(null);
      }
    }
    if(map.containsKey("ks_update_time")) {
      Object obj = map.get("ks_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setKsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setKsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setKsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setKsUpdateTime(null);
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPayTime(null);
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cps_type")) {
      Object obj = map.get("cps_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCpsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("co_type")) {
      Object obj = map.get("co_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recv_time")) {
      Object obj = map.get("recv_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRecvTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRecvTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecvTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRecvTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  }
}
