package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * amount_type
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum AmountType {

    _1("1", "正数"),
    _2("2", "负数"),
    _3("3", "全选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AmountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AmountType fromCode(String code) {
        return Stream.of(AmountType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
