package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_label
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum DocumentLabel {

    _1("1", "正常"),
    _2("2", "调整单"),
    _3("3", "全选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentLabel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentLabel fromCode(String code) {
        return Stream.of(DocumentLabel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
