package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_refund_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum DyRefundStatus {

    _1("1", "待退款"),
    _2("2", "退款中"),
    _3("3", "退款成功"),
    _4("4", "退款失败"),
    _5("5", "追缴成功"),
    _0("0", "无需退款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyRefundStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyRefundStatus fromCode(String code) {
        return Stream.of(DyRefundStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
