package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * income_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum IncomeStatus {

    _0("0", "未入账"),
    _1("1", "已入账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IncomeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IncomeStatus fromCode(String code) {
        return Stream.of(IncomeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
