package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_settlement_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum KsSettlementStatus {

    INIT("INIT", "初始化"),
    WAITING("WAITING", "待结算"),
    COMPLETED("COMPLETED", "已结算"),
    CLOSE("CLOSE", "已关闭");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsSettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsSettlementStatus fromCode(String code) {
        return Stream.of(KsSettlementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
