package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_channel
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum OmsChannel {

    JKY("jky", "吉客云"),
    WDGJ("wdgj", "网店管家");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OmsChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsChannel fromCode(String code) {
        return Stream.of(OmsChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
