package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_after_sales_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum PddAfterSalesStatus {

    _0("0", "无售后"),
    _2("2", "买家申请退款，待商家处理"),
    _3("3", "退货退款，待商家处理 "),
    _4("4", "商家同意退款，退款中"),
    _5("5", " 平台同意退款，退款中"),
    _6("6", "驳回退款，待买家处理"),
    _7("7", "已同意退货退款,待用户发货"),
    _8("8", "平台处理中"),
    _9("9", "平台拒绝退款，退款关闭"),
    _10("10", "退款成功"),
    _11("11", "买家撤销"),
    _12("12", "买家逾期未处理，退款失败 "),
    _13("13", "买家逾期，超过有效期 "),
    _14("14", "换货补寄待商家处理"),
    _15("15", "换货补寄待用户处理"),
    _16("16", "换货补寄成功"),
    _17("17", "换货补寄失败"),
    _18("18", "换货补寄待"),
    _21("21", "待商家同意维修"),
    _22("22", "待用户确认发货"),
    _24("24", "维修关闭"),
    _25("25", "维修成功"),
    _27("27", "待用户确认收货"),
    _31("31", "已同意拒收退款，待用户拒收"),
    _32("32", "补寄待商家发货"),
    _33("33", "同意召回后退款，待商家召回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddAfterSalesStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddAfterSalesStatus fromCode(String code) {
        return Stream.of(PddAfterSalesStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
