package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_confirm_status
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public enum PddConfirmStatus {

    _0("0", "未成交"),
    _1("1", "已成交"),
    _2("2", "已取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddConfirmStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddConfirmStatus fromCode(String code) {
        return Stream.of(PddConfirmStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
