package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * jiageguanlimain
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Jiageguanlimain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 商品编码
   */
  private String goodsNo;
  /**
   * 商品名称
   */
  private String goodsName;
  /**
   * 开票价
   */
  private BigDecimal billingPrice;
  /**
   * 零售价
   */
  private BigDecimal sellingPrice;
  /**
   * 成本价
   */
  private BigDecimal costs;
  /**
   * 扩展字段1
   */
  private String jiagezhuext1;
  /**
   * 扩展字段3
   */
  private String jiagezhuext2;
  /**
   * 扩展字段4
   */
  private String jiagezhuext4;
  /**
   * 扩展字段5
   */
  private String jiagezhuext5;
  /**
   * 扩展字段6
   */
  private String jiagezhuext6;
  /**
   * 扩展字段7
   */
  private String jiagezhuext7;
  /**
   * 扩展字段8
   */
  private String jiagezhuext8;
  /**
   * 扩展字段9
   */
  private String jiagezhuext9;
  /**
   * 扩展字段10
   */
  private String jiagezhuext10;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("goods_no", goodsNo);
      map.put("goods_name", goodsName);
      map.put("billing_price", billingPrice);
      map.put("selling_price", sellingPrice);
      map.put("costs", costs);
      map.put("jiagezhuext_1", jiagezhuext1);
      map.put("jiagezhuext_2", jiagezhuext2);
      map.put("jiagezhuext_4", jiagezhuext4);
      map.put("jiagezhuext_5", jiagezhuext5);
      map.put("jiagezhuext_6", jiagezhuext6);
      map.put("jiagezhuext_7", jiagezhuext7);
      map.put("jiagezhuext_8", jiagezhuext8);
      map.put("jiagezhuext_9", jiagezhuext9);
      map.put("jiagezhuext_10", jiagezhuext10);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Jiageguanlimain fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Jiageguanlimain entity = new Jiageguanlimain();

    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_price")) {
      Object obj = map.get("billing_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("selling_price")) {
      Object obj = map.get("selling_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costs")) {
      Object obj = map.get("costs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCosts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCosts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCosts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCosts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCosts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_1")) {
      Object obj = map.get("jiagezhuext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_2")) {
      Object obj = map.get("jiagezhuext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_4")) {
      Object obj = map.get("jiagezhuext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_5")) {
      Object obj = map.get("jiagezhuext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_6")) {
      Object obj = map.get("jiagezhuext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_7")) {
      Object obj = map.get("jiagezhuext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_8")) {
      Object obj = map.get("jiagezhuext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_9")) {
      Object obj = map.get("jiagezhuext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_10")) {
      Object obj = map.get("jiagezhuext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billing_price")) {
      Object obj = map.get("billing_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("selling_price")) {
      Object obj = map.get("selling_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSellingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSellingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSellingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSellingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSellingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("costs")) {
      Object obj = map.get("costs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCosts((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCosts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCosts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCosts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCosts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_1")) {
      Object obj = map.get("jiagezhuext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_2")) {
      Object obj = map.get("jiagezhuext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_4")) {
      Object obj = map.get("jiagezhuext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_5")) {
      Object obj = map.get("jiagezhuext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_6")) {
      Object obj = map.get("jiagezhuext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_7")) {
      Object obj = map.get("jiagezhuext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_8")) {
      Object obj = map.get("jiagezhuext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_9")) {
      Object obj = map.get("jiagezhuext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_10")) {
      Object obj = map.get("jiagezhuext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJiagezhuext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
