package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * receive_collection_write_off_summary
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceiveCollectionWriteOffSummary implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 核销金额
   */
  private BigDecimal writeOffAmount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 凭证编号
   */
  private String documentNo;
  /**
   * 汇总单编号
   */
  private String summaryNo;
  /**
   * 账期
   */
  private String accountPeriod;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * EBS回传状态
   */
  private String ebsBackStatus;
  /**
   * 应收汇总单编号
   */
  private String receiveSummaryNo;
  /**
   * 应收汇总ID
   */
  private Long receiveSummaryId;
  /**
   * 应收凭证编号
   */
  private String receiveDocumentNo;
  /**
   * 作废状态
   */
  private String validStatus;
  /**
   * 收款汇总单编号
   */
  private String sumCollectionOrderId;
  /**
   * 收款汇总单ID
   */
  private Long sumCollectionId;
  /**
   * 收款汇总单凭证编号
   */
  private String sumCollectionDocumentNo;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("write_off_amount", writeOffAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("document_no", documentNo);
      map.put("summary_no", summaryNo);
      map.put("account_period", accountPeriod);
      map.put("error_msg", errorMsg);
      map.put("ebs_back_status", ebsBackStatus);
      map.put("receive_summary_no", receiveSummaryNo);
      map.put("receive_summary_id", receiveSummaryId);
      map.put("receive_document_no", receiveDocumentNo);
      map.put("valid_status", validStatus);
      map.put("sum_collection_order_id", sumCollectionOrderId);
      map.put("sum_collection_id", sumCollectionId);
      map.put("sum_collection_document_no", sumCollectionDocumentNo);

      return map;
  }

  public static ReceiveCollectionWriteOffSummary fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceiveCollectionWriteOffSummary entity = new ReceiveCollectionWriteOffSummary();

    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_no")) {
      Object obj = map.get("summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_no")) {
      Object obj = map.get("receive_summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_id")) {
      Object obj = map.get("receive_summary_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveSummaryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setReceiveSummaryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_document_no")) {
      Object obj = map.get("receive_document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("valid_status")) {
      Object obj = map.get("valid_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValidStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSumCollectionOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_id")) {
      Object obj = map.get("sum_collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSumCollectionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSumCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_document_no")) {
      Object obj = map.get("sum_collection_document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSumCollectionDocumentNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_no")) {
      Object obj = map.get("summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEbsBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_no")) {
      Object obj = map.get("receive_summary_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveSummaryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_summary_id")) {
      Object obj = map.get("receive_summary_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiveSummaryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceiveSummaryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setReceiveSummaryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_document_no")) {
      Object obj = map.get("receive_document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("valid_status")) {
      Object obj = map.get("valid_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setValidStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSumCollectionOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_id")) {
      Object obj = map.get("sum_collection_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSumCollectionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSumCollectionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSumCollectionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_document_no")) {
      Object obj = map.get("sum_collection_document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSumCollectionDocumentNo((String)obj);
        }
      } else{
      }
    }
  }
}
