package com.xforceplus.ultraman.app.policymanagement.metadata.validator;

import com.xforceplus.ultraman.app.policymanagement.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.policymanagement.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-01-13
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PluginCode.class)) {
            isValid = null != PluginCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PluginCode.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = null != DataType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchType.class)) {
            isValid = null != MatchType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleType.class)) {
            isValid = null != HandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ResultType.class)) {
            isValid = null != ResultType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ResultType.class.getSimpleName());
            }
        }
        if(clazz.equals(FailedContinue.class)) {
            isValid = null != FailedContinue.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FailedContinue.class.getSimpleName());
            }
        }
        if(clazz.equals(TbSalesOrderStatus.class)) {
            isValid = null != TbSalesOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TbSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddAfterSalesStatus.class)) {
            isValid = null != PddAfterSalesStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddAfterSalesStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddConfirmStatus.class)) {
            isValid = null != PddConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupRole.class)) {
            isValid = null != PddGroupRole.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddGroupRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddGroupStatus.class)) {
            isValid = null != PddGroupStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddGroupStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddHomeDeliveryType.class)) {
            isValid = null != PddHomeDeliveryType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddHomeDeliveryType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddIsLuckyFlag.class)) {
            isValid = null != PddIsLuckyFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddIsLuckyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PddKktBizType.class)) {
            isValid = null != PddKktBizType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddKktBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderStatus.class)) {
            isValid = null != PddOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddPayType.class)) {
            isValid = null != PddPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddOrderControlStatus.class)) {
            isValid = null != PddOrderControlStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddOrderControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddShippingType.class)) {
            isValid = null != PddShippingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddShippingType.class.getSimpleName());
            }
        }
        if(clazz.equals(PddStockOutHandleStatus.class)) {
            isValid = null != PddStockOutHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddStockOutHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddTradeType.class)) {
            isValid = null != PddTradeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderTypes.class)) {
            isValid = null != DyOrderTypes.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyOrderTypes.class.getSimpleName());
            }
        }
        if(clazz.equals(DyOrderStatys.class)) {
            isValid = null != DyOrderStatys.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyOrderStatys.class.getSimpleName());
            }
        }
        if(clazz.equals(DyPayType.class)) {
            isValid = null != DyPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsOrderStatus.class)) {
            isValid = null != KsOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCpsType.class)) {
            isValid = null != KsCpsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCpsType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCoType.class)) {
            isValid = null != KsCoType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCoType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsPayType.class)) {
            isValid = null != KsPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyTradeType.class)) {
            isValid = null != DyTradeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyTradeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyGoodsType.class)) {
            isValid = null != DyGoodsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyGoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsTradeStatus.class)) {
            isValid = null != OmsTradeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OmsTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderType.class)) {
            isValid = null != ReceivableOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(EcChannel.class)) {
            isValid = null != EcChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EcChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = null != CheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillChangeRecordSource.class)) {
            isValid = null != BillChangeRecordSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillChangeRecordSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableOrderStatus.class)) {
            isValid = null != ReceivableOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayType.class)) {
            isValid = null != JkyPayType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyPayType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeFrom.class)) {
            isValid = null != JkyTradeFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyTradeFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyPayStatus.class)) {
            isValid = null != JkyPayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyPayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyTradeStatus.class)) {
            isValid = null != JkyTradeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyInvoiceType.class)) {
            isValid = null != JkyInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyIsBillCheck.class)) {
            isValid = null != JkyIsBillCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyIsBillCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(JkyLogisticType.class)) {
            isValid = null != JkyLogisticType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JkyLogisticType.class.getSimpleName());
            }
        }
        if(clazz.equals(DealStatus.class)) {
            isValid = null != DealStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DealStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PddRefundOperatorRole.class)) {
            isValid = null != PddRefundOperatorRole.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddRefundOperatorRole.class.getSimpleName());
            }
        }
        if(clazz.equals(PddUserShippingStatus.class)) {
            isValid = null != PddUserShippingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PddUserShippingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleOrderType.class)) {
            isValid = null != DyAfterSaleOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyAfterSaleOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleType.class)) {
            isValid = null != DyAfterSaleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyAfterSaleType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleRefundType.class)) {
            isValid = null != DyAfterSaleRefundType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyAfterSaleRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyRefundType.class)) {
            isValid = null != DyRefundType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyRefundType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyArbitrateStatus.class)) {
            isValid = null != DyArbitrateStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyArbitrateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyRefundStatus.class)) {
            isValid = null != DyRefundStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyRefundStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DyIsAgreeRefuseSign.class)) {
            isValid = null != DyIsAgreeRefuseSign.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyIsAgreeRefuseSign.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAftersaleSubType.class)) {
            isValid = null != DyAftersaleSubType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyAftersaleSubType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyAfterSaleDetilOrderStatus.class)) {
            isValid = null != DyAfterSaleDetilOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyAfterSaleDetilOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DySettlementType.class)) {
            isValid = null != DySettlementType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DySettlementType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpReturnStatus.class)) {
            isValid = null != ErpReturnStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErpReturnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValidStatus.class)) {
            isValid = null != ValidStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ValidStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SumOrderType.class)) {
            isValid = null != SumOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SumOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCollectMode.class)) {
            isValid = null != KsCollectMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCollectMode.class.getSimpleName());
            }
        }
        if(clazz.equals(KsSettlementStatus.class)) {
            isValid = null != KsSettlementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsSettlementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsAfterSaleTradeStatus.class)) {
            isValid = null != OmsAfterSaleTradeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OmsAfterSaleTradeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsAfterSaleReturnType.class)) {
            isValid = null != OmsAfterSaleReturnType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OmsAfterSaleReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckFundFlow.class)) {
            isValid = null != DyCheckFundFlow.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckFundFlow.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckAccountBillDescTag.class)) {
            isValid = null != DyCheckAccountBillDescTag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckAccountBillDescTag.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckBizType.class)) {
            isValid = null != DyCheckBizType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckAccountType.class)) {
            isValid = null != DyCheckAccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckAccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckOrderType.class)) {
            isValid = null != DyCheckOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DyCheckTransSceneTag.class)) {
            isValid = null != DyCheckTransSceneTag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DyCheckTransSceneTag.class.getSimpleName());
            }
        }
        if(clazz.equals(KsCheckInOutType.class)) {
            isValid = null != KsCheckInOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsCheckInOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(SyncOrderStatus.class)) {
            isValid = null != SyncOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SyncOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableSalesOrderStatus.class)) {
            isValid = null != ReceivableSalesOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableSalesOrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffStatus.class)) {
            isValid = null != WriteOffStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WriteOffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(CollectionOrderType.class)) {
            isValid = null != CollectionOrderType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CollectionOrderType.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentsType.class)) {
            isValid = null != DocumentsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocumentsType.class.getSimpleName());
            }
        }
        if(clazz.equals(EbsDocumentsType.class)) {
            isValid = null != EbsDocumentsType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EbsDocumentsType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingStatus.class)) {
            isValid = null != BillingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessGroup.class)) {
            isValid = null != BusinessGroup.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckProcessStatus.class)) {
            isValid = null != CheckProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeType.class)) {
            isValid = null != IncomeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentLabel.class)) {
            isValid = null != DocumentLabel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DocumentLabel.class.getSimpleName());
            }
        }
        if(clazz.equals(AmountType.class)) {
            isValid = null != AmountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AmountType.class.getSimpleName());
            }
        }
        if(clazz.equals(DefaultPrice.class)) {
            isValid = null != DefaultPrice.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DefaultPrice.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceType.class)) {
            isValid = null != PriceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsPrice.class)) {
            isValid = null != GoodsPrice.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsPrice.class.getSimpleName());
            }
        }
        if(clazz.equals(GiftType.class)) {
            isValid = null != GiftType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GiftType.class.getSimpleName());
            }
        }
        if(clazz.equals(PositiveNegative.class)) {
            isValid = null != PositiveNegative.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PositiveNegative.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeStatus.class)) {
            isValid = null != IncomeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckErpBackStatus.class)) {
            isValid = null != CheckErpBackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckErpBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckResult.class)) {
            isValid = null != CheckResult.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckResult.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = null != ConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceivableBusinessType.class)) {
            isValid = null != ReceivableBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceivableBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExistence.class)) {
            isValid = null != InvoiceExistence.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceExistence.class.getSimpleName());
            }
        }
        if(clazz.equals(RecognitionStatus.class)) {
            isValid = null != RecognitionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecognitionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteoffStatus.class)) {
            isValid = null != WriteoffStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WriteoffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsVirtual.class)) {
            isValid = null != IsVirtual.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsVirtual.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleReturnStatus.class)) {
            isValid = null != SaleReturnStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleReturnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataResourceType.class)) {
            isValid = null != DataResourceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataResourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(OmsChannel.class)) {
            isValid = null != OmsChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OmsChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(KshandlingWay.class)) {
            isValid = null != KshandlingWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KshandlingWay.class.getSimpleName());
            }
        }
        if(clazz.equals(KsnegotiateStatus.class)) {
            isValid = null != KsnegotiateStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsnegotiateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Ksrefundstatus.class)) {
            isValid = null != Ksrefundstatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ksrefundstatus.class.getSimpleName());
            }
        }
        if(clazz.equals(KsReceiptStatus.class)) {
            isValid = null != KsReceiptStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DoubleCheckStatus.class)) {
            isValid = null != DoubleCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DoubleCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ContractDebtFlag.class)) {
            isValid = null != ContractDebtFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ContractDebtFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PlatformSubsidyDealStatus.class)) {
            isValid = null != PlatformSubsidyDealStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PlatformSubsidyDealStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
