package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SystemUser;
import com.xforceplus.ultraman.app.policymanagement.service.ISystemUserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 用户系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-10-29
 */
@RestController
public class SystemUserController {

  @Autowired
  private ISystemUserService systemUserServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemUser 用户系统对象
   * @return
   */
  @GetMapping("/systemusers" )
  public XfR getSystemUsers(XfPage page, SystemUser systemUser) {
    return XfR.ok(systemUserServiceImpl.page(page, Wrappers.query(systemUser)));
  }

  /**
   * 通过id查询用户系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemusers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemUserServiceImpl.getById(id));
  }

  /**
   * 新增用户系统对象
   * @param systemUser 用户系统对象
   * @return XfR
   */
  @PostMapping("/systemusers")
  public XfR save(@RequestBody SystemUser systemUser) {
     return XfR.ok(systemUserServiceImpl.save(systemUser));
  }

  /**
   * 修改-传入修改后的全部数据用户系统对象
   * @param systemUser 用户系统对象
   * @return XfR
   */
  @PutMapping("/systemusers/{id}")
  public XfR putUpdate(@RequestBody SystemUser systemUser,@PathVariable Long id) {
      systemUser.setId(id);
      return XfR.ok(systemUserServiceImpl.updateById(systemUser));
  }

  /**
   * 修改-传入修改的数据用户系统对象
   * @param systemUser 用户系统对象
   * @return XfR
   */
  @PatchMapping("/systemusers/{id}")
  public XfR patchUpdate(@RequestBody SystemUser systemUser,@PathVariable Long id) {
      SystemUser upsystemUser = systemUserServiceImpl.getById(id);
      if(upsystemUser != null){
        upsystemUser = ObjectCopyUtils.copyProperties(systemUser,upsystemUser,true);
      }
      return XfR.ok(systemUserServiceImpl.updateById(upsystemUser));
  }

  /**
   * 通过id删除用户系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemusers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemUserServiceImpl.removeById(id));
  }

  @PostMapping("/systemusers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_user");
     params.put("request", condition);

     return XfR.ok(systemUserServiceImpl.querys(params));
  }

}
