package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.CollectionSummary;
import com.xforceplus.ultraman.app.policymanagement.service.ICollectionSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-06
 */
@RestController
public class CollectionSummaryController {

  @Autowired
  private ICollectionSummaryService collectionSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param collectionSummary ${table.comment}
   * @return
   */
  @GetMapping("/collectionsummarys" )
  public XfR getCollectionSummarys(XfPage page, CollectionSummary collectionSummary) {
    return XfR.ok(collectionSummaryServiceImpl.page(page, Wrappers.query(collectionSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/collectionsummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(collectionSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param collectionSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/collectionsummarys")
  public XfR save(@RequestBody CollectionSummary collectionSummary) {
     return XfR.ok(collectionSummaryServiceImpl.save(collectionSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param collectionSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/collectionsummarys/{id}")
  public XfR putUpdate(@RequestBody CollectionSummary collectionSummary,@PathVariable Long id) {
      collectionSummary.setId(id);
      return XfR.ok(collectionSummaryServiceImpl.updateById(collectionSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param collectionSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/collectionsummarys/{id}")
  public XfR patchUpdate(@RequestBody CollectionSummary collectionSummary,@PathVariable Long id) {
      CollectionSummary upcollectionSummary = collectionSummaryServiceImpl.getById(id);
      if(upcollectionSummary != null){
        upcollectionSummary = ObjectCopyUtils.copyProperties(collectionSummary,upcollectionSummary,true);
      }
      return XfR.ok(collectionSummaryServiceImpl.updateById(upcollectionSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/collectionsummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(collectionSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/collectionsummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "collection_summary");
     params.put("request", condition);

     return XfR.ok(collectionSummaryServiceImpl.querys(params));
  }

}
